import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GUI extends JFrame implements ActionListener {

	Engine engine = new Engine();
	JButton proveri = new JButton("Proveri");
	Dugme kombinacija[] = new Dugme[4];
	Dugme ponudjeni[] = new Dugme[6];
	Dugme pokusaji[][] = new Dugme[6][4];
	Dugme pogodjeni[][] = new Dugme[6][4];
	JPanel istok, zapad, jug;
	
	public GUI() {
		
		setTitle("Skocko");
		setBounds(600,200,800,700);
		
		//zapad
		zapad = new JPanel(new GridLayout(6, 4, 5, 5));
		for (int i = 0; i < 6; i++) {
			for (int j = 0; j < 4; j++) {
				pokusaji[i][j] = new Dugme(i, j);
				pokusaji[i][j].setBackground(Color.WHITE);
				pokusaji[i][j].setPreferredSize(new Dimension(70,80));
				pokusaji[i][j].setEnabled(false);
				zapad.add(pokusaji[i][j]);
			}
		}
		getContentPane().add(zapad, BorderLayout.WEST);
		
		//istok
		istok = new JPanel(new GridLayout(6, 4, 5, 5));
		for (int i = 0; i < 6; i++) {
			for (int j = 0; j < 4; j++) {
				pogodjeni[i][j] = new Dugme(i, j);
				pogodjeni[i][j].setBackground(Color.WHITE);
				pogodjeni[i][j].setPreferredSize(new Dimension(70,80));
				pogodjeni[i][j].setEnabled(false);
				istok.add(pogodjeni[i][j]);
			}
		}
		getContentPane().add(istok, BorderLayout.EAST);
		
		//jug
		jug = new JPanel(new FlowLayout());
		for (int i = 0; i < kombinacija.length; i++) {
			kombinacija[i] = new Dugme(i);
			kombinacija[i].setBackground(Color.white);
			kombinacija[i].setPreferredSize(new Dimension(70,80));
			kombinacija[i].setEnabled(false);
			jug.add(kombinacija[i]);
		}
		
		for (int i = 0; i < 6; i++) {
			ponudjeni[i] = new Dugme(i);
			ponudjeni[i].setPreferredSize(new Dimension(50,50));
			ponudjeni[i].addActionListener(this);
			jug.add(ponudjeni[i], BorderLayout.SOUTH);
		}
		ImageIcon image = new ImageIcon("slike/pik.jpg");
		ponudjeni[0].setIcon(image);
		image = new ImageIcon("slike/karo.png");
		ponudjeni[1].setIcon(image);
		image = new ImageIcon("slike/srce.jpg");
		ponudjeni[2].setIcon(image);
		image = new ImageIcon("slike/tref.png");
		ponudjeni[3].setIcon(image);
		image = new ImageIcon("slike/zvezda.png");
		ponudjeni[4].setIcon(image);
		image = new ImageIcon("slike/skocko.jpg");
		ponudjeni[5].setIcon(image);
		
		proveri.setFocusable(false);
		proveri.setBackground(Color.white);
		proveri.setPreferredSize(new Dimension(100,40));
		proveri.addActionListener(this);
		jug.add(proveri);
		
		getContentPane().add(jug, BorderLayout.SOUTH);
		
		enablujRed();
		
		pack();
		setVisible(true);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		
	}
	
	private void prikaziKombinaciju() {
		ImageIcon image;
		for (int i = 0; i < kombinacija.length; i++) {
			kombinacija[i].setEnabled(true);
			if(engine.kombinacija[i].indexSlike == 0) {
				image = new ImageIcon("slike/pik.jpg");
				kombinacija[i].setIcon(image);
			}
			else if(engine.kombinacija[i].indexSlike == 1) {
				image = new ImageIcon("slike/karo.png");
				kombinacija[i].setIcon(image);
			}
			else if(engine.kombinacija[i].indexSlike == 2) {
				image = new ImageIcon("slike/srce.jpg");
				kombinacija[i].setIcon(image);
			}
			else if(engine.kombinacija[i].indexSlike == 3) {
				image = new ImageIcon("slike/tref.png");
				kombinacija[i].setIcon(image);
			}
			else if(engine.kombinacija[i].indexSlike == 4) {
				image = new ImageIcon("slike/zvezda.png");
				kombinacija[i].setIcon(image);
			}
			else {
				image = new ImageIcon("slike/skocko.jpg");
				kombinacija[i].setIcon(image);
			}
		}
	}
	
	private void enablujRed() {
		for (int i = 0; i < 6; i++) {
			for (int j = 0; j < 4; j++) {
				if(i == engine.redKojiSeObradjuje) {
					pokusaji[i][j].setEnabled(true);
				}
			}
		}
	}

	
	public void osveziPrikaz() {
		ImageIcon image;
		for (int i = 0; i < 6; i++) {
			for (int j = 0; j < 4; j++) {
				if(engine.pokusaji[i][j].indexSlike == 0) {
					image = new ImageIcon("slike/pik.jpg");
					pokusaji[i][j].setIcon(image);
				}
				else if(engine.pokusaji[i][j].indexSlike == 1) {
					image = new ImageIcon("slike/karo.png");
					pokusaji[i][j].setIcon(image);
				}
				else if(engine.pokusaji[i][j].indexSlike == 2) {
					image = new ImageIcon("slike/srce.jpg");
					pokusaji[i][j].setIcon(image);
				}
				else if(engine.pokusaji[i][j].indexSlike == 3) {
					image = new ImageIcon("slike/tref.png");
					pokusaji[i][j].setIcon(image);
				}
				else if(engine.pokusaji[i][j].indexSlike == 4) {
					image = new ImageIcon("slike/zvezda.png");
					pokusaji[i][j].setIcon(image);
				}
				else if(engine.pokusaji[i][j].indexSlike == 5) {
					image = new ImageIcon("slike/skocko.jpg");
					pokusaji[i][j].setIcon(image);
				}
				else {
					pokusaji[i][j].setIcon(null);
					pokusaji[i][j].setBackground(Color.white);
				}
			}
		}
		
		for (int i = 0; i < 6; i++) {
			for (int j = 0; j < 4; j++) {
				if(engine.pogodjeni[i][j].indexSlike == 6) {
					pogodjeni[i][j].setBackground(Color.red);
				}
				else if(engine.pogodjeni[i][j].indexSlike == 7) {
					pogodjeni[i][j].setBackground(Color.yellow);
				}
				else {
					pogodjeni[i][j].setBackground(Color.white);
				}
			}
		}
		
		for (int i = 0; i < kombinacija.length; i++) {
			kombinacija[i].setIcon(null);
			kombinacija[i].setBackground(Color.WHITE);
		}
		
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub

		if(e.getSource() == proveri) {
			//System.out.println("provera");
			if(engine.proveraReda()) {
				if(engine.pogodjeno == true) {
					//kraj POBEDA
					osveziPrikaz();
					prikaziKombinaciju();
					int odgovor = new JOptionPane().showConfirmDialog(null, "POBEDIO SI. Da li zelis novu partiju?", "Igra je gotova", JOptionPane.YES_NO_OPTION);
					if(odgovor == JOptionPane.YES_OPTION) {
						engine.inicijalizuj();
						engine.napraviKombinaciju();
						osveziPrikaz();
					}
					else {
						System.exit(1);
					}
				}
				else if(engine.redKojiSeObradjuje == 6) {
					//kraj IZGUBIO SI
					osveziPrikaz();
					prikaziKombinaciju();
					int odgovor = new JOptionPane().showConfirmDialog(null, "IZGUBIO SI. Da li zelis novu partiju?", "Igra je gotova", JOptionPane.YES_NO_OPTION);
					if(odgovor == JOptionPane.YES_OPTION) {
						engine.inicijalizuj();
						engine.napraviKombinaciju();
						osveziPrikaz();
					}
					else {
						System.exit(1);
					}
				}
				osveziPrikaz();
				enablujRed();
			}
		}
		else if(e.getSource() instanceof Dugme) {
			//System.out.println("ponudjeni");
			Dugme dugme = (Dugme)e.getSource();
			engine.popuniPolje(dugme.index);
			osveziPrikaz();
		}
			
	}

}







